definition module LinkerMessages;

//1.3
from StdString import String;
//3.1
from StdBool import not;
from StdList import isEmpty;

// Linker Messages; messages should added in reverse order
:: LinkerMessagesState = { 
		ok						:: !Bool
	,	messages				:: LinkerMessages
	};
	
:: LinkerMessages :== [LinkerMessage];

:: LinkerMessage 
	= LinkerError !String
	| LinkerWarning !String
	| Verbose !String
	;
	
// Operations on Linker Messages
DefaultLinkerMessages :: !LinkerMessagesState;

class LinkError .a
where {
	isLinkerErrorOccured :: !.a -> (!Bool,!.a);
	
	addLinkMessage :: !LinkerMessage !.a -> !.a
};

//1.3
instance LinkError !LinkerMessagesState;
//3.1
/*2.0
instance LinkError LinkerMessagesState;
0.2*/


setLinkerMessages :: !LinkerMessages !.LinkerMessagesState -> !.LinkerMessagesState;

setLinkerError error :== setLinkerMessages [LinkerError error] DefaultLinkerMessages;
getLinkerMessages :: !LinkerMessagesState -> [String];
get_LinkerMessages :: !LinkerMessagesState -> !LinkerMessages;

addLinkerMessage message linker_messages_state :== setLinkerMessages [message] linker_messages_state;

// ADDED
class AddMessage .a 
where {
	AddMessage :: !LinkerMessage !*a -> !*a;
	
	IsErrorOccured :: !*a -> !(!Bool,!*a);
	
	GetLinkerMessages :: !*a -> (!LinkerMessages,!*a);
	
	SetLinkerMessages :: !LinkerMessages !*a -> !*a
};